<?php defined('SYSPATH') or die('No direct script access.');

class User_tokens extends Migration{

    public $schema = 'public';
    public $table = 'user_tokens';

    public function up(){
        $this->run_query(DB::expr(
            "CREATE TABLE user_tokens(
                id serial,
                user_id integer NOT NULL REFERENCES users(id) ON DELETE CASCADE,
                user_agent varchar(40) NOT NULL,
                token varchar(40) NOT NULL,
                created integer NOT NULL,
                expires integer NOT NULL,
                CONSTRAINT user_tokens_id_pkey PRIMARY KEY (id),
                CONSTRAINT user_tokens_token_key UNIQUE (token)
            );"
        ));
    }

    public function down(){
        $this->set_schema($this->schema);
        $this->drop_table($this->table);
    }
}